<?php
/*
 * Plugin Name: WooCommerce Custom Product Addons (Free)
 * Version: 2.7.6
 * Plugin URI: https://acowebs.com
 * Description: WooCommerce Product add-on plugin. Add custom fields to your WooCommerce product page. With an easy-to-use Custom Form Builder, now you can add extra product options quickly.
 * Author URI: https://acowebs.com
 * Author: Acowebs
 * Requires at least: 4.0
 * Tested up to: 6.2
 * Requires PHP: 5.6
 * Text Domain: woo-custom-product-addons
 * WC requires at least: 3.3.0
 * WC tested up to: 7.6
 */

if ( ! defined('ABSPATH')) {
    exit;
}


if ( ! is_wcpa_pro_active()) {
    define('WCPA_POST_TYPE', 'wcpa_pt_forms');
    define('WCPA_LIST_PAGE_HOOCK', 'wcpa_manage');
    define('WCPA_CART_ITEM_KEY', 'wcpa_data');

    if ( ! defined('WCPA_UPLOAD_DIR')) {
        define('WCPA_UPLOAD_DIR', 'wcpa_uploads');
    }
    define('WCPA_PRODUCT_META_KEY', '_wcpa_product_meta');
    define('WCPA_PRODUCT_META_FIELD', 'wcpa_product_meta');
    define('WCPA_ORDER_META_KEY', '_WCPA_order_meta_data');
    define('WCPA_TEXT_DOMAIN', 'woo-custom-product-addons');
    define('WCPA_FORM_META_KEY', '_wcpa_fb-editor-data');
    define('WCPA_SETTINGS_KEY', 'wcpa_settings_key');
    define('WCPA_META_SETTINGS_KEY', 'wcpa_meta_settings_key');
    define('WCPA_PRODUCTS_TRANSIENT_KEY', 'wcpa_products_transient');
    define('WCPA_TOKEN', 'wcpa');
    define('WCPA_VERSION', '2.7.6');
    define('WCPA_FILE', __FILE__);
    define('WCPA_PLUGIN_NAME', 'WooCommerce Custom Product Addons (Free)');



    require_once(realpath(plugin_dir_path(__FILE__)).DIRECTORY_SEPARATOR.'includes/helpers.php');

    function wcpa_init()
    {
        $plugin_rel_path = basename(dirname(__FILE__)).'/languages'; /* Relative to WP_PLUGIN_DIR */

        load_plugin_textdomain('woo-custom-product-addons', false, $plugin_rel_path);
    }

    add_action('plugins_loaded', 'wcpa_init');
    function wcpa_autoloader($class_name)
    {
        if (0 === strpos($class_name, 'WCPA')) {
            $classes_dir = realpath(plugin_dir_path(__FILE__)).DIRECTORY_SEPARATOR.'includes'.DIRECTORY_SEPARATOR;
            $class_file  = 'class-'.str_replace('_', '-', strtolower($class_name)).'.php';
            require_once $classes_dir.$class_file;
        }
    }

    spl_autoload_register('wcpa_autoloader');

// Declare compatibility with custom order tables for WooCommerce.
    add_action(
        'before_woocommerce_init',
        function () {
            if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
                \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __DIR__,
                    true);
            }
        }
    );

    if ( ! function_exists('WCPA')) {
        function WCPA()
        {
            return WCPA_Backend::instance(__FILE__, WCPA_VERSION);
        }
    }
    if ( ! function_exists('WCPAFront')) {
        function WCPAFront()
        {
            return WCPA_Front_End::instance(__FILE__, WCPA_VERSION);
        }
    }
    if (is_admin()) {
        WCPA();
    }

    WCPAFront();
}

function is_wcpa_pro_active()
{
    if (in_array('woo-custom-product-addons-pro/start.php',
        apply_filters('active_plugins', get_option('active_plugins')))) {
        return true;
    }
    if (is_multisite()) {
        $plugins = get_site_option('active_sitewide_plugins');
        if (isset($plugins['woo-custom-product-addons-pro/start.php'])) {
            return true;
        }
    }

    return false;
}